<?php
/*--------------------------------------------------------------------------------------------------
    OnSellingUnitIdCreateEvent.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\SellingUnit\Unit\Events;

use Gambio\Shop\SellingUnit\Unit\Builders\Interfaces\SellingUnitIdBuilderInterface;
use Gambio\Shop\SellingUnit\Unit\Builders\SellingUnitIdBuilder;
use Gambio\Shop\SellingUnit\Unit\Events\Interfaces\OnSellingUnitIdCreateEventInterface;

class OnSellingUnitIdCreateEvent implements OnSellingUnitIdCreateEventInterface
{
    /**
     * @var SellingUnitIdBuilderInterface
     */
    protected $builder;
    /**
     * @var string
     */
    private $type;
    /**
     * @var mixed
     */
    private $value;
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value()
    {
        return $this->value;
    }
    
    /**
     * @inheritDoc
     */
    public function builder(): SellingUnitIdBuilderInterface
    {
        return $this->builder;
    }
    
    
    /**
     * OnSellingUnitIdCreateEvent constructor.
     *
     * @param string $type
     * @param        $value
     */
    public function __construct(string $type, $value)
    {
    
        $this->type = $type;
        $this->value = $value;
        $this->builder = new SellingUnitIdBuilder();
    }
}